/*
 * Decompiled with CFR 0.152.
 */
package com.hachionUserDashboard.controller;

import Service.AdminService;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.hachionUserDashboard.dto.LoginRequest;
import com.hachionUserDashboard.entity.Admin;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/admin"})
@CrossOrigin
public class AdminController {
    @Autowired
    private AdminService adminService;

    @PostMapping(value={"/create"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> createAdmin(@RequestPart(value="admin") String adminJson, @RequestPart(value="Logo", required=false) MultipartFile Logo, @RequestPart(value="Banner", required=false) MultipartFile Banner, @RequestPart(value="Mark", required=false) MultipartFile Mark, @RequestPart(value="Know", required=false) MultipartFile Know, @RequestPart(value="Play", required=false) MultipartFile Play, @RequestPart(value="Ads1", required=false) MultipartFile Ads1, @RequestPart(value="Ads2", required=false) MultipartFile Ads2, @RequestPart(value="Home", required=false) MultipartFile Home, @RequestPart(value="app_icon", required=true) MultipartFile app_icon) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            Admin admin = (Admin)mapper.readValue(adminJson, Admin.class);
            Admin savedAdmin = this.adminService.createAdmin(admin, Logo, Mark, Know, Play, Ads1, Ads2, Home, Banner, app_icon);
            return new ResponseEntity((Object)savedAdmin, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<List<Admin>> getAllAdmins() {
        return ResponseEntity.ok((Object)this.adminService.getAllAdmins());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Admin> getAdmin(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.adminService.getAdminById(id));
    }

    @PutMapping(value={"/update/{id}"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> updateAdmin(@PathVariable Long id, @RequestPart(value="admin") String adminJson, @RequestPart(value="Logo", required=false) MultipartFile Logo, @RequestPart(value="Banner", required=false) MultipartFile Banner, @RequestPart(value="Mark", required=false) MultipartFile Mark, @RequestPart(value="Know", required=false) MultipartFile Know, @RequestPart(value="Play", required=false) MultipartFile Play, @RequestPart(value="Ads1", required=false) MultipartFile Ads1, @RequestPart(value="Ads2", required=false) MultipartFile Ads2, @RequestPart(value="Home", required=false) MultipartFile Home) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            Admin admin = (Admin)mapper.readValue(adminJson, Admin.class);
            Admin updatedAdmin = this.adminService.updateAdmin(id, admin, Logo, Home, Mark, Know, Play, Ads1, Ads2, Banner);
            return ResponseEntity.ok((Object)updatedAdmin);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/details/{uniqueId}/{appName}"})
    public ResponseEntity<?> getDetailsByUniqueIdAndAppName(@PathVariable String uniqueId, @PathVariable String appName) {
        Admin admin = this.adminService.getByUniqueIdAndAppName(uniqueId, appName);
        if (admin != null) {
            return ResponseEntity.ok((Object)admin);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"No matching record found");
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<?> login(@RequestBody LoginRequest loginRequest) {
        System.out.println("Email: " + loginRequest.getEmail());
        System.out.println("Password: " + loginRequest.getPassword());
        try {
            String email = loginRequest.getEmail();
            String password = loginRequest.getPassword();
            Admin admin = this.adminService.findByEmailAndPassword(email, password);
            if (admin == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Invalid credentials");
            }
            return ResponseEntity.ok((Object)admin);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteAdmin(@PathVariable Long id) {
        this.adminService.deleteAdmin(id);
        return ResponseEntity.noContent().build();
    }

    private String saveFile(MultipartFile file) throws IOException {
        String fileName = UUID.randomUUID().toString() + "_" + file.getOriginalFilename();
        Path filePath = Paths.get("uploads", fileName);
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
        return fileName;
    }
}

