/*
 * Decompiled with CFR 0.152.
 */
package com.hachionUserDashboard.service;

import Service.AdminService;
import com.hachionUserDashboard.entity.Admin;
import com.hachionUserDashboard.repository.AdminRepository;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class Adminimpl
implements AdminService {
    @Autowired
    private AdminRepository adminRepository;
    @Value(value="${upload.path}")
    private String uploadPath;

    private String saveFile(MultipartFile file) throws IOException {
        File dir = new File(this.uploadPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = UUID.randomUUID().toString() + "_" + file.getOriginalFilename();
        File destFile = new File(dir, fileName);
        file.transferTo(destFile);
        return "uploads/" + fileName;
    }

    public Admin createAdmin(Admin admin, MultipartFile Logo, MultipartFile Mark, MultipartFile Know, MultipartFile Play, MultipartFile Ads1, MultipartFile Ads2, MultipartFile Home, MultipartFile Banner, MultipartFile app_icon) {
        try {
            String LogoPath;
            if (Logo != null && !Logo.isEmpty()) {
                LogoPath = this.saveFile(Logo);
                admin.setLogo(LogoPath);
            }
            if (Banner != null && !Banner.isEmpty()) {
                LogoPath = this.saveFile(Banner);
                admin.setBanner(LogoPath);
            }
            if (Mark != null && !Mark.isEmpty()) {
                LogoPath = this.saveFile(Mark);
                admin.setMark(LogoPath);
            }
            if (Know != null && !Know.isEmpty()) {
                LogoPath = this.saveFile(Know);
                admin.setKnow(LogoPath);
            }
            if (Play != null && !Play.isEmpty()) {
                LogoPath = this.saveFile(Play);
                admin.setPlay(LogoPath);
            }
            if (Ads1 != null && !Ads1.isEmpty()) {
                LogoPath = this.saveFile(Ads1);
                admin.setAds1(LogoPath);
            }
            if (Ads2 != null && !Ads2.isEmpty()) {
                LogoPath = this.saveFile(Ads2);
                admin.setAds2(LogoPath);
            }
            if (Home != null && !Home.isEmpty()) {
                String mapPath = this.saveFile(Home);
                admin.setHome(mapPath);
            }
            if (app_icon != null && !app_icon.isEmpty()) {
                String app_iconPath = this.saveFile(app_icon);
                admin.setApp_icon(app_iconPath);
            }
            return (Admin)this.adminRepository.save((Object)admin);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save admin data: " + e.getMessage());
        }
    }

    public Admin updateAdmin(Long id, Admin updatedAdmin, MultipartFile Logo, MultipartFile Banner, MultipartFile Mark, MultipartFile Know, MultipartFile Play, MultipartFile Ads1, MultipartFile Ads2, MultipartFile Home) {
        Optional optionalAdmin = this.adminRepository.findById((Object)id);
        if (!optionalAdmin.isPresent()) {
            throw new RuntimeException("Admin not found with id: " + id);
        }
        Admin existingAdmin = (Admin)optionalAdmin.get();
        existingAdmin.setCompanyName(updatedAdmin.getCompanyName());
        existingAdmin.setPhone(updatedAdmin.getPhone());
        existingAdmin.setPage1_link(updatedAdmin.getPage1_link());
        existingAdmin.setPage1(updatedAdmin.getPage1());
        existingAdmin.setPage2(updatedAdmin.getPage2());
        existingAdmin.setPage2_link(updatedAdmin.getPage2_link());
        existingAdmin.setPage3(updatedAdmin.getPage3());
        existingAdmin.setPage3_link(updatedAdmin.getPage3_link());
        existingAdmin.setPage4(updatedAdmin.getPage4());
        existingAdmin.setPage4_link(updatedAdmin.getPage4_link());
        existingAdmin.setPage5(updatedAdmin.getPage5());
        existingAdmin.setPage5_link(updatedAdmin.getPage5_link());
        existingAdmin.setPage6(updatedAdmin.getPage6());
        existingAdmin.setPage6_link(updatedAdmin.getPage6_link());
        try {
            if (Logo != null && !Logo.isEmpty()) {
                String LogoPath = this.saveFile(Logo);
                existingAdmin.setLogo(LogoPath);
            }
            if (Home != null && !Home.isEmpty()) {
                String mapPath = this.saveFile(Home);
                existingAdmin.setHome(mapPath);
            }
            if (Mark != null && !Mark.isEmpty()) {
                String MarkPath = this.saveFile(Mark);
                existingAdmin.setMark(MarkPath);
            }
            if (Know != null && !Know.isEmpty()) {
                String KnowPath = this.saveFile(Know);
                existingAdmin.setKnow(KnowPath);
            }
            if (Play != null && !Play.isEmpty()) {
                String PlayPath = this.saveFile(Play);
                existingAdmin.setPlay(PlayPath);
            }
            if (Ads1 != null && !Ads1.isEmpty()) {
                String Ads1Path = this.saveFile(Ads1);
                existingAdmin.setAds1(Ads1Path);
            }
            if (Ads2 != null && !Ads2.isEmpty()) {
                String Ads2Path = this.saveFile(Ads2);
                existingAdmin.setAds2(Ads2Path);
            }
            if (Banner != null && !Banner.isEmpty()) {
                String bannerPath = this.saveFile(Banner);
                existingAdmin.setBanner(bannerPath);
            }
            return (Admin)this.adminRepository.save((Object)existingAdmin);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update admin data: " + e.getMessage());
        }
    }

    public Admin getAdminById(Long id) {
        return (Admin)this.adminRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Admin not found with id: " + id));
    }

    public List<Admin> getAllAdmins() {
        return this.adminRepository.findAll();
    }

    public void deleteAdmin(Long id) {
        this.adminRepository.deleteById((Object)id);
    }

    public Admin findByEmailAndPassword(String email, String password) {
        return this.adminRepository.findByEmailAndPassword(email, password).orElse(null);
    }

    public Admin getByUniqueIdAndAppName(String uniqueId, String appName) {
        return this.adminRepository.findByUniqueIdAndAppName(uniqueId, appName).orElse(null);
    }
}

